exclude:
type: header
name: heading section
bookInfo:
  title: Regent
  version: 1.1
  series: The Last Pharaoh
  author: Jay Penner
  pubDate: 15-Aug-2020
  coverImage: ./resources/regent.cover.jpg 
replacers: 
  d1 : "> ![](div.2.png)"
  d2 : "> ![](div.2.png)"
  buyLink: https://gen.us/tlp-regent
buildControls: 
    outputName: Sample 
    includeCoverImage: true 
    wordTemplate: ./templates/novel.docx 
    ePubStyleSheet: ./templates/novel.css 
    formats:
        - docx

---

synopsis: notes and scratch sheet. Make a copy of this file and modify it for your purposes.
1.0 - for PQ sample

=============================================

---

# 

![](regent.cover.jpg)

=============================================

name: ch2

synopsis: series entry

---

#

##### REGENT

### _Sample Pages Only_

> *The Last Pharaoh: BOOK I*

>

> by Jay Penner

> ------

> **Series**

> Book I: _Regent_

> Book II: _Queen_

> Book III: _Empress_ (final)

> Prequel novella: _A Dangerous Daughter_

\

\

> {{myWeb}}

=============================================

name: sample reminder

---

#

#### SAMPLE PAGES

\

\

> _These pages are provided as a sample to demonstrate the capabilities of the pq script. You are free to modify them for personal use to test and experiment._

=============================================

synopsis: dedication

---

# 

\

\

> _To the women of the world._

=============================================

name: copyright

---

# 

The Last Pharaoh - Book I Copyright © 2020 by Jay Penner. All Rights Reserved.  
  
All rights reserved. No part of this book may be reproduced in any form or by any electronic or mechanical means including information storage and retrieval systems, without permission in writing from the author. The only exception is by a reviewer, who may quote short excerpts in a review.   
  
This book is a work of fiction. Names, characters, places, and incidents either are products of the author’s imagination or are used fictitiously. Any resemblance to actual persons, living or dead, events, or locales is entirely coincidental.   
  
Jay Penner [https://www.jaypenner.com](https://www.jaypenner.com)   
  
Printed in the United States of America   
  
First Printing: October 2020

####### version {{version}}
####### produced using: https://publishquickly.com

=============================================

name: chotherworks

---

# 

![](all.books.jpg)

=============================================

name: ch3

synopsis: Pre-reading notes

---

# BEFORE YOU READ

{{d2}}

Writing about the Ptolemaic dynasty, including its most famous members like Cleopatra, is a very tricky undertaking. The reality is that very little of the specific period (from the Egyptian side) actually exists by way of contemporary literature or architecture. Even ancient accounts, which are based on even older accounts, don’t always agree. And those oldest accounts? Even those were written decades after the lives of the dynasty. The only impactful contemporary work (from the Roman side), Julius Caesar’s Commentaries on the Civil War, mentions Cleopatra briefly—that too in a dispassionate and dry manner as Caesar recounts major events. But he says absolutely nothing about personal characteristics or relationships (understandable, given his tricky situation).

One of the most important things to be aware of is that almost everything we know about the principal characters comes from a stilted *Roman vantage* written a hundred (*Plutarch*) to two hundred (*Dio*) years *after* the major events in this book!

Imagine reading a recently written book about a popular political character that lived a hundred years ago, written by an author who was fundamentally aligned to a regime that was *against* that figure, by using accounts mostly from people of that regime! I provide a detailed notes section at the end of the series to explain some of my thinking.

It is important to recognize that this trilogy is a *novel*, and at its heart, the purpose is to take you to an ancient world and entertain you. This is not an academic paper! Having said that, I have tried to maintain general alignment to major milestones of the last decades of Ptolemaic rule, and many events and descriptions of ways of life are borrowed from historical sources.

The rest, well, how do you know *it didn’t happen?*

=============================================

name: ch4

synopsis: a description of treatment of anachronisms

---

# Anachronisms

{{d2}}

> *an act of attributing customs, events, or objects to a period to which they do not belong*

Writing in the ancient past sometimes makes it difficult to explain everyday terms. Therefore, I have taken certain liberties so that the reader is not burdened by linguistic gymnastics or forced to do mental math (how far is 60 stadia again? What is an Artaba?). My usage is meant to convey the meaning behind the term, rather than striving for historical accuracy. I hope that you will come along for the ride, even as you notice that certain concepts may not have existed during the period of the book. For example:

> *Directions*—North, South, East, West.

>

> *Time*—Years, Minutes, Hours, Weeks, Months, Years.

>

> *Distance*—Meters, Miles.

>

> *Measures*—Gallons, Tons.

=============================================

name: ch5

synopsis: people

---

# DRAMATIS PERSONAE

{{d2}}

> **Ptolemy XII Neos Dionysos Philopator Philadelphos**–King of Egypt, twelfth ruler of the Ptolemaic dynasty, derisively called “Auletes” (Flutist)

>

> **Cleopatra**–Second daughter of King Ptolemy XII

>

> **Arsinoe**–Third daughter of King Ptolemy XII, Cleopatra’s younger sister

>

> **Ptolemy XIII and XIV**–Sons of King Ptolemy, younger brothers of Cleopatra and Arsinoe

>

> **Pothinus**–First Eunuch of the Royal Court, Regent, Chief Advisor and Tutor to the Royals

>

> **Theodotus**–Teacher of rhetoric, advisor to the Royals

>

> **Apollodorus the Sicilian**–Commander of Cleopatra’s army

>

> **Achillas**–General of King Ptolemy’s forces

>

> **Gaius Julius Caesar**–Roman Consul, General

>

> **Pompey Magnus**–Roman Consul, General

=============================================

name: ch6

synopsis: terms

---

# TERMS

{{d2}}

> **Gladius**–a 1.5 to 2 ft. long sword, typically used by Roman soldiers

>

> **Uraeus Crown**–the Pharaonic crown with the upright cobra in the front

>

> **Shendyt**–Egyptian attire: skirt-like garment worn around the waist, falling to the ankles.

>

> **Chiton, Peplos**–Greek gowns

=============================================

name: ch7

pov: Cleopatra

synopsis: Cleopatra attempts to negotiate

---

# ALEXANDRIA

## AUGUST 29, 30 B.C.

{{d1}}

The cool basalt floor hid the cauldron of emotions as she waited for the man to arrive. The massive oak doors remained closed. It was dark inside, with a single column of light gliding through an open window, forming a rectangular pattern on the floor. Her two attendants fidgeted nervously. One came near her, fussing over the slightly ruffled robe, smoothing it. She adjusted her diadem and straightened a few unruly curls of her reddish-brown hair.

“Iras. Leave it alone.”

“Yes, Your Majesty,” Iras said, and retreated into the darkness.

From beneath the doors, the Alexandrian sunlight made a futile attempt to bathe the floor, failing after just a few inches. But movement outside signaled arrival through a play of shadows.

She waited. She had only suggested that he see her. She was never the one to seek an audience. The fine robe irritated her chest, raw from the ritual beating by her own open palms as she had previously mourned the death of the man she loved, and on whose future she had linked hers. The red welts were calmer now, with a medicinal salve applied gently over them, and then protected with a soothing rose paste.

The shadows shifted–a distinctly different pattern from that of the guards. The door creaked and opened inward. She flinched as the impatient sun, unhappy at being kept out so long, rushed in and smothered her in his warm embrace. And there, with the blinding light to his back, was the silhouette of a man.

He walked in quietly, and his men stayed back. Her eyes adjusted to the light as she studied him.

*This is him?*

She was surprised. The man in the purple toga looked like a gangly teenager. He was only a few years younger than her, and she was nearly forty years of age. He made no sign of respect or supplication. Here she was, a divinity of the goddess Isis, worshipped by her people, and there he stood, with no sign of reverence. She had heard much about him but had never seen him.

He shifted on his feet. He moved awkwardly. There was no confidence of a conqueror. He was not as tall as his uncle and had none of the burly handsomeness of the lover and husband who had died in her arms a few days ago.

Perhaps she could still come out victorious in this situation, like she had many times in her life, in other difficult circumstances.

His eyes refused to meet hers. They danced furtively, glancing every which way but at hers, like a nervous love-struck young boy mustering the courage to talk to a girl who waits for him.

But she knew. His eyes showed no devotion, no admiration, no affection. In fact, they showed nothing at all. The glassy-gray eyes had no mirth in them.

“Your Majesty,” he said, finally. His voice was slight, hoarse, almost whispery. Heavy yet characterless, like wet sand. Like a boring tutor’s.

“General,” she said. She would not call him with the term he most desired. A rank higher than what he aspired to. A rank bequeathed upon him by a great man who she once loved.

He looked back. Iras pointed to a stool in the corner, and the man modestly walked over and pulled it towards him. A simple, wood-carved three-leg with a fine dark-brown cushion.

He sat. He kept his knees together. *Almost like a woman*, she thought. And then he placed his palms on his thighs. He brushed his curls to the side but continued to look at the floor.

“You walk in here like you are a conqueror,” she said almost playfully. Her Latin was accented, and thus she was hampered by her inability to play with the words. In Greek, she could string words like magnificent plays or mellifluous music, appealing to the mind and the heart. She could take her voice to sumptuous highs and perilous lows, enthralling her listeners. But she knew this man responded to Latin and little else.

*Should have spent more time neutralizing my accent. Speak like one of his own.*

The conversation would be direct.

Simple.

She expected him to smile. Or laugh. Or retort with something. But he did none of that. He continued to stare at a different section of the floor.

He arched his back, and then stared at her feet.

*How do I engage this man who refuses to look at my face or reason with my voice?* she wondered.

“Your armies are finished. Your man is dead,” he finally said.

“My armies stood down to avoid needless bloodshed, General,” she said. “And my husband gave his life to prevent more conflict.”

He finally looked at her. A cool, composed stare. The unblinking stare of a man studying his opponent’s words. Measuring. Calculating. Choosing a response.

He took his time. And she knew she could not snap her fingers and have him obey her commands.

“So you say. My demands are simple.”

Her cheeks reddened and heat suffused her face. “You land here, in my sacred city, threaten us, spread nefarious propaganda about our ways, and wish me to believe you?”

*And you do not know that my son, borne of a great man and who, one day, will replace you, is now on the way to India, to bide his time,* she thought.

He placed his palms on his thighs again. His eyes were like a crow’s. “You seduced great men of my nation and made fools of them for your own benefit. You drew a sword on my sister’s dignity by causing her divorce. Your man sought to break our republic while cavorting in bed with you. And you say it is I who spreads propaganda?”

His voice rose a little. It rasped more when he was excited. She liked it. That meant he *felt* something. And when a man felt something, it could be taken advantage of.

She leaned back and rested on her fine ruby-red pillow. “You are a man that knows the immense burden of rule. Your women have no voice. You think that all the impieties and improprieties are men’s domain, and therefore you are threatened by the manifestation of a goddess who behaves as if she is a man.”

He appraised her. The slightest smile passed his lips. “I am threatened by nothing.”

“And yet, here you are. Knowing that without my endorsement, you will have little of Egypt’s treasures or its people’s cooperation.”

“It was you who sought an interview,” he said evenly.

“I only politely asked if you wished to meet me, and here you are.”

He looked at a dark corner of the vast chamber. And finally he said, “Your children are under my protection.”

Her heart pounded against her already hurting ribs. She was weak, having eaten less in the last two days, after recovering from a fever caused by the inflammation of the raw wounds on her chest. She allowed her attendant to wipe a sheen of sweat of her eyebrows, even as the man watched, dispassionately.

“Spare them. They seek to do no harm. They are babes in the battle between great nations,” she said, her chin trembling. Sufficient to invoke pity, she hoped, even if the act was partly true. Her children were all she had left. Not her kingdom. Not her army. Not the men she loved. Not her generals.

“You defied me every step of the way. You sought an alliance with a man you knew desired to do me harm,” he said. His voice had risen again. But worryingly, he had not answered her demand to spare her children.

“I did no such thing. It was ten years ago. He coerced me into an alliance–”

His hand shot up, his palm facing her, as if to say *enough!* She was taken aback. No man, except her lovers who fought with her in the privacy of her rooms, had ever demanded that she be quiet. She took a sharp breath.

“You seduced him using the most devious means. You clouded his judgment. I know all about the ship in Tarsus. Your extravagant, bacchanalian parties. He coerced you to nothing!” he rasped, and yet when he spoke, he continued to stare at a meaningless space near his feet.

She controlled her smile. “I did what a divine ruler and a Pharaoh of Egypt would do. Why do you begrudge me to do what my people expected of me when you have played politics with endless lives yourselves? I played no part–”

“You sought to entice Herod to turn on me. You provided ships to guard your lover’s navy’s rear and ran when you realized there would be no victory.”

*He speaks like a mathematician, devoid of emotion.*

She looked at him with tearful eyes. “I wish to speak of your mercy to my children.”

“And I wish to speak of reparations. Of payments to my men. Of peaceful transition.”

“In return for the safety of my children. For assurances that they will succeed to my throne.”

He raised his head, finally looking her in the eye.

*What a strange man,* she thought. *A conqueror. No doubt a man desired by women of all ages, and yet so awkward.*

“I assure you of nothing beyond the just treatment of yourself and your children.”

A gentle wave of relief swept over her. Perhaps there was a future.

“That would–”

He leaned forward, cutting her off again.

“But you should accompany me to Rome with them.”

=============================================

name: ch8

pov: Cleopatra

synopsis: part entry

---

# 

#### TWENTY-TWO YEARS EARLIER

=============================================

name: ch9

synopsis: maps

---

# 

##### PART I

###### ![](tlp.map.region.jpg)

####### maps data: Google (c) 2021 

=============================================

name: ch10

pov: Pothinus

synopsis: Pothinus takes the royals on a trip

---

# CHAPTER {{#n}}

## ALEXANDRIA

### POTHINUS

{{d1}}

The three royals walked along glorious colonnaded halls lined with sphinxes, trailed by guards, and led by their tutor.

Pothinus, the tutor, the highest-ranked eunuch of the royal court and advisor to His Majesty Ptolemy, was today taking them on a trip to one of the most respected sites in their city. Alexander’s mausoleum, called the *Soma*. There, he would impart wisdom to the youngest member, the ten-year-old Ptolemy Theos Philopator—*Ptolemy, god, Father-Loving*—one who would be king in due time. The boy’s two sisters came along, mischievous as they were, wishing to needle their brother while relishing the visit themselves. He knew, as he had tutored them too, that they intensely desired to be here–a location even they were not allowed to visit when they wanted.

There was hushed silence when they finally arrived in the grand sacred room, its walls made of the finest marble and painted with murals of the great conqueror’s deeds, its columns decorated with vines of gold, and the floors alive with the most magnificent blue-and-orange patterns.

In the center was a sarcophagus, quite plain. The lid was thick glass, sufficiently transparent to gaze upon the mummy of a great man who had died three hundred years ago. Pothinus was always pained by the forlorn look of this sarcophagus, once glorious with lustrous golden plates and rubies, now all stripped away due to their father’s mismanagement of finances and indebtedness to the bastards in Rome.

The royals stood quietly while Pothinus turned and addressed the young prince—skinny, short, wearing a fine white tunic held at the waist by golden threads.

“The first Macedonian Pharaoh of Egypt,” Pothinus said. “A god to the people, a king to your great-great-great-grandfather, one who ruled the world before the gods decided he belonged in their company.”

Ptolemy walked closer to the sarcophagus. The glass was higher than his little majesty’s eye level. He was a slim and short boy. Pothinus raised an eyebrow at an attendant, who scurried away to bring a stool.

“No, wait,” said one of the teen girls, His Royal Highness’ sister, with a serious tone. The attendant froze and waited.

“You should probably bring a ladder,” she said, and the two sisters began to giggle.

“Your Highness Princess Cleopatra!” Pothinus reprimanded her, as was his right as her tutor. He was perhaps one of the three people in the entire world who could raise his voice to the royal children and refer to them by names, as circumstances permitted. “And you as well, Princess Arsinoe. Behave yourselves.”

While they were sometimes insufferable, as girls of their age are sometimes wont to be, Cleopatra was Pothinus’ favorite. Sharp, quick-witted, willing to learn, manipulative, and stubborn, she challenged him and kept his mind fresh as a garden of roses. She was sixteen and readying herself to be a regent, though His Majesty had not yet appointed her so. For this occasion, she had dressed in a lovely white Greek gown and made sure to tie her hair in a bun, wore gold bracelets, and carried with her a bronze staff that she loved to point at things and pretend to be a tutor. Cleopatra had an oval face, a prominent nose with a slight high bridge in the middle, and beautiful glass-gray eyes. When she smiled, a dimple developed on her right cheek.

Cleopatra’s sister, Arsinoe, wore a sheer blue silk drapery tied around the waist with silver threads. She wore a pearl necklace and three gold rings with ruby studs. Of the two, Pothinus thought quietly, Arsinoe was the truly pretty one, with her sharp nose, dove-like eyes, and elegant face, though she was a challenge to deal with because of her fiery temper and reckless mind.

“Yes, Pothinus, whatever you say,” Cleopatra said with a smile, even as she elbowed her sister.

His Highness Ptolemy, used to their needling, wagged a ringed finger. “Father will hear of this!”

“Father will hear of this,” imitated Arsinoe, shaking her head theatrically. Arsinoe was two years younger than Cleopatra, feisty and often unruly.

“Alright. Enough. My Prince, please ascend the stool and gaze upon the great conqueror,” Pothinus said, even as he eyed the sisters and gestured *be quiet* while allowing a smile to escape.

They spent the next hour with Pothinus summarizing Alexander’s conquests, his relation to the Ptolemies, the glory of the Ptolemies, and the children’s own roles in this world. It always fascinated them, no matter how many times they heard or read about it, that their forefather Ptolemy I Soter was a companion of Alexander the Great himself, had fought by his side for years, and then had become the satrap and Pharaoh of Egypt after Alexander’s death. They were also tickled by the fascinating fact that Ptolemy Soter had hijacked Alexander’s body while it was on the way to Macedonia, and brought it to Egypt.

Pothinus tried to mollify the boy-prince. “You are an embodiment of a god, Your Highness, and one day you will rule this great kingdom from a throne–”

“A stool. Maybe a ladder!” said Arsinoe, and the girls dissolved into peals of laughter, causing Pothinus to admonish them again. *Should not have brought these two along!* Cleopatra had a sweet voice, like her mother’s, soft and lilting, and she was adept at modulating it. Arsinoe still had the crackling voice of a young teen that broke when she laughed.

Tears sprang to Ptolemy’s eyes. “I will have you both executed!” he yelled, imitating his father.

*That would not be the first time*, thought Pothinus, for this dynasty had no shortages of executions amongst themselves.

“No one needs to die, Your Majesty. You must pardon the insolence of your sisters,” Pothinus said, even as the girls composed themselves.

“Besides, one day, one of them will become your wife and will have to listen to you,” he said with a flourish.

At that, their faces fell, a sight Pothinus enjoyed somewhat.

Ptolemy grinned. “You will do as I command!”

Arsinoe crinkled her nose and Cleopatra pretended not to hear. The lectures were over, and they would return to the palace, where they would shift to loudly reading works of great Greek masters while balancing thirty-foot long papyrus scrolls. The hours could be long and grueling, their throats sore from the recitation and feet aching from sitting cross-legged. But Pothinus thought the children did well, considering the tutors could not beat them, and discipline was reserved to kneeling or being told on to the king, who sometimes thrashed them to obedience. And thrash them, he did, even if rarely. Young Ptolemy still had bruises on his thigh, and Cleopatra had permanent scarring on her forearm, the effect of a bamboo stick.

Pothinus fell behind Ptolemy and walked beside Cleopatra. “You should stop harassing him so, Your Highness. Little seeds of anger in a young mind can grow into fertile trees of revenge. One day he will be king.”

“He is just ten, Pothinus. He won’t remember.”

“Does your bright mind not remember the days when you were ten, the games with Berenice, and your reluctance to travel to Rome with your father?”

Cleopatra fell silent at these words, no doubt remembering very well what had transpired years ago.

*The young princess has much to learn*, Pothinus thought.

“Your father has ordered your presence in a week’s time. He desires for you to begin participating in administrative matters.”

Cleopatra beamed. Arsinoe chimed in, “Why not me?”

Pothinus regarded the younger girl. “Your time will arrive, Your Highness.”

“She always gets the first chance,” Arsinoe pouted.

“Because I am older! Have you forgotten that Berenice ruled for two years in our father’s absence? Not me,” Cleopatra said. Ptolemy had walked far ahead, his little crown bobbing on his head and his gown trailing on the spotless floor.

“She was mean,” Arsinoe said.

“Now she is dead,” Cleopatra retorted, and they both grinned.

*There are no certainties in your own lives, princesses,* Pothinus thought, for in how many families had a father executed his own daughter, as His Majesty Ptolemy had done to his daughter Berenice?

There was a commotion out front, and a courtier came running towards them. He knelt before Cleopatra and Arsinoe.

“Your Highness, His Majesty has become severely ill. The royal court requests your presence immediately. Your Excellency Pothinus, yours as well.”

=============================================

name: ch11

pov: Pothinus

synopsis: An urgent missive regarding the king

---

# CHAPTER {{#n}}

## ALEXANDRIA

### POTHINUS

{{d1}}

Court officials had to make hasty preparations for appointing a regent due to the king’s rapidly deteriorating health. Ptolemy Dionysos–the children’s father–had not spoken for two days. Physicians tended to him, hopeful that he would regain his faculties and return to his duties. Pothinus, as the principal advisor and the First Eunuch of the court, had the king’s ear. His Majesty had more than once told Pothinus that he valued his words. *There will come a time when I must decide who will sit beside me as regent. My son is too young. I will seek your opinion*, he had said, and unfortunately once in front of Arsinoe.

And now Arsinoe would not let it go. Of the two sisters, she was the more stubborn and hot-headed one. She was like a wild horse, untamed, and only afraid of one man–her father–who was now incommunicative. She cornered Pothinus as he hurried to the royal quarters where he was summoned. Physicians had sent word that His Majesty had regained consciousness.

“Pothinus!” she yelled, her crackling teen voice reflecting off the stone columns of the vast hall.

“Your Highness, I must see His Majesty at the earliest,” he said, not slowing down. Pothinus was tall, and his legs demonstrated a sense of urgency. But Arsinoe sprang like a gazelle, her brown-black hair bouncing as she gained on him. Pothinus resisted the urge to run, for that would be the most comical scene. As much as he was the children’s tutor and guide and appointed with special privileges by the king himself, there were limits to his liberties.

“Wait. I must speak to you,” she said, now close. Pothinus increased his pace, fervently hoping for the distant door to appear in front of him. But that was not to be.

“Pothinus! I order you!”

*The girl was unstoppable.*

“Yes, Your Highness,” he sighed as he stopped and turned.

“I heard he is awake,” she said, looking up at him.

“As have I, Your Highness, and I have been summoned. I must–”

“He will appoint a regent, won’t he?”

“It is His Majesty’s decision, Your Highness. And I do not know what the king wishes to do.”

“He is going to appoint a regent,” she said stubbornly. “He will appoint Cleopatra!”

“Who His Majesty wishes to–”

“She is like Berenice, Pothinus, do you not see? She is cunning, and she will try to get rid of Father!” Arsinoe said almost frantically, surprising Pothinus.

“She is older than you, Your Highness, and I think we both agree that the king decides who it will be,” Pothinus said, desperate to get away from this dangerous, uncomfortable conversation. The walls had ears, and not all of those ears were favorable to Pothinus.

“He listens to you, Pothinus. You should tell him that it should be me,” she said, fixing her sparkling eyes on him.

*Her intensity will one day burn her,* Pothinus thought, but he had to defuse the situation.

“If His Majesty wishes to–”

“Of course he will!”

*Let me speak, child!*

“If his Majesty wishes to know of my opinion, I will make sure to mention your wonderful strength and intelligence, Your Highness,” he said as he leaned forward, almost addressing her as if she were the pupil.

Arsinoe did not seem convinced. “I am not in your class,” she retorted, her eyes flashing impatience. “You should tell him that Cleopatra is like her older sister, conniving and not with my father’s best interests at heart.”

Pothinus regarded the girl. She was fourteen and saw herself a queen. She swayed between the haughtiness of a princess with ambition, and a temperamental teen who thought they knew more than they did and were distracted by new things.

“I will convey my reservations about your sister, Your Highness, but you are gracious enough to recognize my difficulties in speaking ill of any child of His Majesty’s.”

“Yes, yes, I know,” she clucked. “But you can use the right words. Perhaps you can get Theodotus’ help. He is probably there in the chamber as well.”

Theodotus. *The rhetorician, big mouth and a bigger ego,* Pothinus thought. He had nothing to learn from that bloated head, who was another tutor for the royal children.

“I will, Your Highness, and you know that I will always have your best interests at heart,” Pothinus said as he bent lower to bring his eyes to the level of the feisty princess. Arsinoe was short, and Pothinus almost had the urge to lift her up, like he did when she was younger, and tell her to calm down.

Arsinoe finally smiled. She patted his shoulder. “I know. You may go,” she finally said.

Pothinus regarded the energetic princess. What drove her to these swings between affection for her sister, and anger towards her? He had never really asked that question.

“Princess?”

“Yes?” she said, suddenly looking vulnerable.

“Why do you fear your sister so much? I see you both laughing and spending time together, and yet here you are, worried,” he said gently, in the soothing voice of a tutor.

Arsinoe’s features softened. She wrung her palms together. “I have read all our family’s history, Pothinus,” she said softly. “And I cannot forget.”

Pothinus understood. He did not respond. Instead, he took both her hands and told her, “But you have nothing to be worried about.”

“It is easy for you to say. I am sure all the tutors in the past said the same too, to the ones who died. Many of my forefathers and mothers have killed off their husbands, sisters, brothers, mothers, fathers. It is frightening. I like Cleopatra, but you know that she is clever, Pothinus! She will kill my brothers and me. I am sure of that,” she said fearfully.

How could he assuage the fears of a fourteen-year-old who, in a moment of maturity, had said aloud what he had himself pondered about? Cleopatra had two younger brothers—the youngest one still a toddler.

Arsinoe took a deep breath. And then, as she turned to walk away, she paused. She stepped close to Pothinus and whispered, “I saw it.”

Pothinus was confused. “Saw what, Princess?”

“Berenice,” she said, still whispering, referring to her older sister.

“What about Berenice?”

Arsinoe’s eyes became moist. “Father did not know I was behind the pillars…”

Pothinus’ heart began to race.

“On his orders, they dragged her away screaming. She was crying and shouting when they cut off her head in the walled garden near my room. There was so much blood! I saw it all,” she said, almost becoming hysterical. “She used to beat us and say hurtful things. And I heard she had her husband strangled. Cleopatra may become like my father, or her!”

“Oh, you poor child,” Pothinus said, extending his arms like a father. He held Arsinoe briefly. “Your personal tutor Ganymedes and I will protect you, Princess,” he said. “And I can assure you that your sister has never once, not even as a joke, ever said she wishes to rid herself of her siblings. She loves you. Now go, Princess, for I must hurry to the king.”

Pothinus knew then that this fear would never leave Arsinoe—and the fear, combined with her temper, would pose a great challenge.

Arsinoe turned to her maids, who were waiting at a distance, and sprinted towards them, no doubt suddenly anxious about a different matter that was most important to girls of her age.

Pothinus sighed. He knew this was not over.

He rushed to the king’s chamber. His Majesty had awakened, and he seemed to have sufficient clarity of mind. The king often lost himself in his music festivals and bouts of drinking, all of which increasingly worsened his health.

After the initial courtesies and small talk, the king prepared to discuss the question of regency.

“Cleopatra is of age and should be ready, but Arsinoe is not one to be dismissed,” Ptolemy said. Pothinus knew that the king loved both his daughters, cherishing specific characters in each. “My son will have to wait.”

Pothinus agreed. It was wise to let His Majesty speak some more before opining on the matter himself. There were others in the room, and no doubt some reported the happenings back to the princesses.

The king looked sickly. His large eyes had a yellowish pallor, and his ample jowls sagged, a sign Pothinus knew to be a result of excessive drinking.

King Ptolemy turned to Pothinus. “What do you say?”

“As Your Majesty indicates. Her Highness Cleopatra has the age and intelligence, and Her Highness Arsinoe has the fiery countenance fit for a princess.”

Ptolemy smiled. “You say much, Pothinus, and yet you say nothing.”

Pothinus grinned at the king’s astute observation. “It is my honor and privilege to tutor and advise Their Highnesses, Your Majesty, and I am like a mother who cannot favor one hungry child over another.”

The king nodded. “Achillas is not here,” he said.

“The general is dealing with self-important mercenaries causing mischief outside Alexandria, Your Majesty,” an adjutant said.

“I am tired. I wish to retreat from some of my daily duties,” King Ptolemy said. “And since none of you will give me firm opinions, perhaps Arsinoe it will be. I will announce tomorrow.”

Pothinus was surprised. His Majesty stared at the men around his bed, who kept their heads low and said nothing. The king’s eyes shifted to Pothinus, who first squirmed, and then he mustered the courage.

“Your Majesty…”

“Yes?”

“May I take this opportunity of your presence to bring to your notice another matter of importance?”

Ptolemy gestured for Pothinus to come closer.

Pothinus leaned forward, confident that if he whispered, then no one could hear. “May I offer an opinion on the choice, Your Majesty?”

The king nodded. For all of Ptolemy’s long list of shortcomings and failings, one redeeming feature of the king was that he would at least listen to his advisors, even if he ignored most of what they said.

Pothinus whispered, “Regency requires nuance and the ability to connect to the common people and listen to them, Your Majesty. Princess Arsinoe has the fire of a warrior within her, but what you need is someone who can administer, and not one who charges to battle. The lion is still on the throne,” he said diplomatically.

The king broke into a smile. “What use is an advisor who does not speak when he must?”

Pothinus retreated. The audience looked to the king, who raised himself and sat upright, resting against a pillow.

“I have decided,” he said.

=============================================

name: ch84

synopsis: end notes and thank you

---

# THANK YOU FOR READING

{{d2}}

I would be immensely grateful if you took a few minutes to either rate the book or leave a review if you enjoyed it. This makes a huge difference to new authors like me. You can go to [https://jaypenner.com/review](https://jaypenner.com/review) for easy links.

I hope you enjoyed reading this book! What happens in the next? Well, we’re going to meet the quirky but dangerous Herod and the impetuous Mark Antony, for starters. Grab _Queen, The Last Pharaoh Book II_ to continue the saga.

Want to virtually visit the locations mentioned in this book through a cool Google Earth flyby? There’s something really exciting about going to the locations and imagining what it might have been like two thousand years ago. Go to [{{maps}}]({{maps}}) and ONLY visit the Book I map (because the callouts may have spoilers). I hope you find it informative and fun.

You will find detailed notes at the end of the third book addressing many questions--about the characters (who was real and who was not?), the events (Cleopatra’s meeting of Caesar, Achillas’ and Pothinus’ deaths, Arsinoe’s imprisonment), and the timelines.

By the way, did you wonder about _Eurydice_, mentioned by Cleopatra as one she was inspired to learn languages from? Check out my highly rated Whispers of Atlantis series–exciting books that take you to a world around the times of Alexander, and to the time when Cleopatra’s ancestor, Ptolemy Soter, founded the Ptolemaic dynasty.

Until next time!

{{sig}}

=============================================

name: ch85

synopsis:

---

# REFERENCES

{{d2}}

The following works provided helpful historical references and commentary on the life of Cleopatra.

1.  Cleopatra, a Life, by Stacy Schiff–Little, Brown and Company

2.  The Parallel Lives by Plutarch, Loeb Classical Library edition–Life of Caesar, Pompey, and Antony (writing eighty to a hundred years after the events of this book)

3.  Civil Wars by Julius Caesar, Loeb Classical Library–Book III (contemporary)

4.  Alexandrian Wars, possibly in the name of Julius Caesar, Loeb Classical Library–contemporary

5.  Showtime–The Hunt for Cleopatra’s tomb

6.  Cassius Dio, Roman History, Loeb Classical Library (writing about two hundred years after the events in this book)

7.  Cicero’s Letters to Atticus, Project Gutenburg, Translated by E. O. Winstedt

=============================================

